/**
* Script: inventorystate.js
* Written by: Radnen
* Updated: 1/14/2011
**/

RequireScript("ui/equipbox.js");

function InventoryState(name)
{
	this.inherit = GUIState;
	this.inherit(name);
		
	var panel = this.createBasePanel();
	panel.useWindow = false;
		
	var text = new Label(panel, "Player's Inventory:");
	text.useWindow = true;
	text.xx = 24;
	text.yy = 24;
	text.w = 128;
	text.h = 16;
	
	var text2 = new Label(panel, "Equipment:");
	text2.useWindow = true;
	text2.xx = SW-128;
	text2.yy = 24;
	text2.w = 80;
	text2.h = 16;

	var inv = new ItemSet(panel, 48, 72, 6, 5, 16, 16);
	var equip = new EquipmentBox(panel, SW-120, 64, 72, 72, 16, 16);
	
	function equip_item() {
		if (inv.item) {
			if (!Genesis.player.canEquip(inv.item)) {
				Audio.playSound(Resources.sounds.cant);
				return;
			}
			var item = inv.item;
			var olditem = equip.unequipSlot(Items[item].type);

			if (olditem != null) {
				inv.items.push(olditem);
				Items[olditem].unequip();
			}
			
			Audio.playSound(Resources.sounds.click);
			equip.equipSlot(Items[item]);
			Utility.remove(inv.items, item);
			Items[item].equip();
		}
	}
	
	inv.onItemDoubleClick = equip_item;

	equip.useWindow = true;
	//equip.addSlot(28, 4, "nav");
	equip.addSlot(4, 28, "left");
	equip.addSlot(52, 28, "right");
	equip.addSlot(28, 28, "constant");
	//equip.addSlot(28, 52, "booster");
	equip.addSlot(52, 52, "secondary");
	
	equip.onItemDoubleClick = function() {
		if (!this.slot) return;
		var item = this.unequipSlot(this.slot.type);
		if (item != null) {
			Audio.playSound(Resources.sounds.cancel);			
			inv.items.push(item);
			Items[item].unequip();
		}
	}
	
	panel.controls.push(text);
	panel.controls.push(text2);
	panel.controls.push(inv);
	panel.controls.push(equip);

	this.doInput = function(key) {
		switch(key) {
			case KEY_ESCAPE: this.hide(); break;
		}
	}
	
	this.onEnter.add(function() {
		inv.items = Genesis.player.inventory;
		inv.onSelect();
		equip.setEquipment();
	});
	
	this.onLeave.add(function() {
		Genesis.player.inventory = inv.items;
	});
}